<?xml version="1.0"?>
<!-- 
Data creazione: 06/10/2011

Validatore INA-SAIA per i flussi di poplamento ACSOR, basato sulla versione:
http://inasaiafaq.ancitel.it/images/File/INA-SAIA_Allegato_tecnico_2_Struttura_Dati_AP5_v.1.19.pdf 

Legenda:
	- Esito POSITIVO: L'output restituisce solo il "Totali comunicazioni processate []"
    - Esito NEGATIVO: L'output restituisce il numero della comunicazione errata, il CF relativo e il motivo.
			I motivi possono essere:
				-  Popolamento non riconosciuto per tag <motivoComunicazione> diverso da codice 22,23,24.
				-  Popolamento per informazioni generali obbligatorie mancanti.
				-  Popolamento residenti,deceduti e/o emigrati per scorretto utilizzo di iscrizione/cancellazione APR
-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">
	<xsl:output method="text" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<xsl:text>**** Validatore file di Popolamento INA-SAIA per il sistema ACSOR. Versione 1.0 ****</xsl:text>
		<xsl:text>&#x0D;</xsl:text>
		<xsl:text>Totali comunicazioni processate [</xsl:text>
		<xsl:value-of select="count(/richiestaSAIA/richiesta/comunicazione)"/>
		<xsl:text>]&#x0D;&#x0D;</xsl:text>
		<xsl:for-each select="/richiestaSAIA/richiesta/comunicazione">
			<!-- check comunicazione di - Errore: Popolamento-->
			<xsl:if test="not(. /causale/motivoComunicazione=22 or  
					  . /causale/motivoComunicazione=23 or
					  . /causale/motivoComunicazione=24)">
				<xsl:text>- Errore: Popolamento non riconosciuto per CF [</xsl:text>
				<xsl:value-of select="./generalita/codiceFiscale"/>] ,comunicazione N. [<xsl:value-of select="position()"/>
				<xsl:text>]&#x0D;</xsl:text>
			</xsl:if>
			<xsl:if test=". /causale/motivoComunicazione=22 or  
					  . /causale/motivoComunicazione=23 or
					  . /causale/motivoComunicazione=24">
				<!-- check generalità -->
				<xsl:if test="not(./generalita/codiceFiscale and
											./generalita/cognome and
											./generalita/nome and
											./generalita/luogoNascita and
											./generalita/dataNascita and
											./generalita/sesso and
											./generalita/cittadinanza and
											./indirizzo)">
					<xsl:text>- Errore: Popolamento generalità non corretto per CF [</xsl:text>
					<xsl:value-of select="./generalita/codiceFiscale"/>] ,comunicazione N. [<xsl:value-of select="position()"/>
					<xsl:text>]&#x0D;</xsl:text>
				</xsl:if>
			</xsl:if>
			<!-- check dipendenza tag iscrizione/cancellazione APR-->
			<xsl:choose>
				<xsl:when test=". /causale/motivoComunicazione = 22">
					<xsl:if test="not(./iscrizioneAPR)">
						<xsl:text>- Errore: Popolamento residenti non corretto per CF [</xsl:text>
						<xsl:value-of select="./generalita/codiceFiscale"/>] ,comunicazione N. [<xsl:value-of select="position()"/>
						<xsl:text>]&#x0D;</xsl:text>
					</xsl:if>
				</xsl:when>
				<xsl:when test=". /causale/motivoComunicazione = 23">
					<xsl:if test="not(./cancellazioneAPR)">
						<xsl:text>- Errore: Popolamento deceduti non corretto per CF [</xsl:text>
						<xsl:value-of select="./generalita/codiceFiscale"/>] ,comunicazione N. [<xsl:value-of select="position()"/>
						<xsl:text>]&#x0D;</xsl:text>
					</xsl:if>
				</xsl:when>
				<xsl:when test=". /causale/motivoComunicazione = 24">
					<xsl:if test="not(./cancellazioneAPR)">
						<xsl:text>- Errore: Popolamento emigrati non corretto per CF [</xsl:text>
						<xsl:value-of select="./generalita/codiceFiscale"/>] ,comunicazione N. [<xsl:value-of select="position()"/>
						<xsl:text>]&#x0D;</xsl:text>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		<xsl:text>&#x0D;Fine Elaborazione!!!</xsl:text>
	</xsl:template>
</xsl:stylesheet>
